
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_TestingStatus : BaseTest 
	{

		private DataTable _dtTestingStatus;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtTestingStatus = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM TestingStatus", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetTestingStatusLookupList_Pass()
		{
			DataTable dtTest = DAL.TestingStatus.GetTestingStatusLookupList();

			Assert.AreEqual(dtTest.Rows.Count, this._dtTestingStatus.Rows.Count , "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingStatus.TestingStatusId), TABLES.TestingStatus.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingStatus.TestingStatusText), TABLES.TestingStatus.TestingStatusText);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestingStatusLookupList_Fail()
		{
		}

		[Test]
		public void GetTestingStatusTextFromId_Pass()
		{
			int statusId = System.Convert.ToInt32(this._dtTestingStatus.Rows[0][TABLES.TestingStatus.TestingStatusId]);
			string tmpValue = DAL.TestingStatus.GetTestingStatusTextFromID(statusId);

			Assert.AreEqual(this._dtTestingStatus.Rows[0][TABLES.TestingStatus.TestingStatusText].ToString(), tmpValue);
		}

		[Test]
        [ExpectedExceptionAttribute(typeof(Common.DataAccessLayerException))]
		public void GetTestingStatusTextFromId_Fail()
		{
			//TODO: default condition in DAL.TestingStatus.GetTestingStatusTextFromID can be removed - unreachable
			//TestingStatusId is PrimaryKey, only 0 or 1 rows will EVER be returned.
			DAL.TestingStatus.GetTestingStatusTextFromID(int.MinValue);
		}
	}
}

#endif





